/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.publication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.Uklib;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.UklibFragment;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.UklibModule;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.publication.ArchiveUklibTask;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.serialization.UklibSerializationKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@DisableCachingByDefault(because="This task only compresses Uklib into an archive")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR:\u0010\f\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u00020\u00138G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/ArchiveUklibTask;", "Lorg/gradle/api/DefaultTask;", "()V", "fragments", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/UklibFragment;", "getFragments", "()Lorg/gradle/api/provider/ListProperty;", "outputZip", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputZip", "()Lorg/gradle/api/file/RegularFileProperty;", "taskDependencies", "Lorg/gradle/api/provider/Provider;", "", "kotlin.jvm.PlatformType", "getTaskDependencies", "()Lorg/gradle/api/provider/Provider;", "temporariesDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getTemporariesDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "run", "", "UklibWithDuplicateAttributes", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nArchiveUklibTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiveUklibTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/ArchiveUklibTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,95:1\n766#2:96\n857#2,2:97\n1477#2:99\n1502#2,3:100\n1505#2,3:110\n1238#2,2:122\n1549#2:124\n1620#2,3:125\n1241#2:128\n357#3,7:103\n511#3:113\n496#3,6:114\n438#3:120\n388#3:121\n*S KotlinDebug\n*F\n+ 1 ArchiveUklibTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/ArchiveUklibTask\n*L\n68#1:96\n68#1:97,2\n75#1:99\n75#1:100,3\n75#1:110,3\n78#1:122,2\n78#1:124\n78#1:125,3\n78#1:128\n75#1:103,7\n76#1:113\n76#1:114,6\n78#1:120\n78#1:121\n*E\n"})
public abstract class ArchiveUklibTask
extends DefaultTask {
    private final Provider<String> taskDependencies = this.getFragments().map((Transformer)taskDependencies.1.INSTANCE);
    @NotNull
    private final RegularFileProperty outputZip;
    @NotNull
    private final DirectoryProperty temporariesDirectory;

    public ArchiveUklibTask() {
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty().convention(this.getProject().getLayout().getBuildDirectory().file("kotlin/uklibs/" + this.getProject().getName() + ".uklib"));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProp\u2026.UKLIB_EXTENSION}\")\n    )");
        this.outputZip = regularFileProperty;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty().convention(this.getProject().getLayout().getBuildDirectory().dir("kotlin/uklibs_tmp"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.director\u2026kotlin/uklibs_tmp\")\n    )");
        this.temporariesDirectory = directoryProperty;
    }

    @Nested
    @NotNull
    public abstract ListProperty<UklibFragment> getFragments();

    @Input
    protected final Provider<String> getTaskDependencies() {
        return this.taskDependencies;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getOutputZip() {
        return this.outputZip;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getTemporariesDirectory() {
        return this.temporariesDirectory;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        Map $this$filterTo$iv$iv;
        Object value$iv$iv$iv;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Object element$iv$iv22;
        void $this$filterTo$iv$iv2;
        Object object = this.getFragments().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fragments.get()");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv22 : $this$filterTo$iv$iv2) {
            UklibFragment fragment = (UklibFragment)element$iv$iv22;
            boolean bl = false;
            boolean isMetadata = ((Collection)fragment.getAttributes()).size() > 1;
            boolean isASkippedMetadataCompilation = isMetadata && !fragment.getFile().exists();
            if (!(!isASkippedMetadataCompilation)) continue;
            destination$iv$iv.add(element$iv$iv22);
        }
        List compiledFragments = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = compiledFragments;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        element$iv$iv22 = $this$groupByTo$iv$iv.iterator();
        while (element$iv$iv22.hasNext()) {
            Object object2;
            element$iv$iv = element$iv$iv22.next();
            UklibFragment it = (UklibFragment)element$iv$iv;
            boolean bl = false;
            Set<String> key$iv$iv = it.getAttributes();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv2 = destination$iv$iv2;
        boolean $i$f$filter2 = false;
        $this$groupByTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        element$iv$iv22 = $this$filterTo$iv$iv.entrySet().iterator();
        while (element$iv$iv22.hasNext()) {
            Object it = element$iv$iv = (Map.Entry)element$iv$iv22.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map bambooFragments = destination$iv$iv2;
        if (!bambooFragments.isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = bambooFragments;
            boolean $i$f$mapValues = false;
            $this$filterTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapTo$iv$iv;
                void it;
                void it$iv$iv;
                Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl3 = false;
                Iterable $this$map$iv = (Iterable)it.getValue();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    UklibFragment uklibFragment = (UklibFragment)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl4 = false;
                    collection.add(it2.getIdentifier());
                }
                Set set = CollectionsKt.toSet((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)));
                map2.put(k, set);
            }
            Map map = destination$iv$iv2;
            throw new UklibWithDuplicateAttributes(map);
        }
        FileUtilsKt.getFile((Provider<RegularFile>)((Provider)this.outputZip)).getParentFile().mkdirs();
        FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.temporariesDirectory)).mkdirs();
        UklibSerializationKt.serializeToZipArchive(new Uklib(new UklibModule(CollectionsKt.toSet((Iterable)compiledFragments)), "0.0.1"), FileUtilsKt.getFile((Provider<RegularFile>)((Provider)this.outputZip)), FileUtilsKt.getDirectoryAsFile((Provider<Directory>)((Provider)this.temporariesDirectory)));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00060\u0001j\u0002`\u0002B-\u0012&\u0010\u0003\u001a\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\b0\u00050\u0004\u00a2\u0006\u0002\u0010\tJ)\u0010\f\u001a\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\b0\u00050\u0004H\u00c6\u0003J3\u0010\r\u001a\u00020\u00002(\b\u0002\u0010\u0003\u001a\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\b0\u00050\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R1\u0010\u0003\u001a\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\b0\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/ArchiveUklibTask$UklibWithDuplicateAttributes;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "duplicates", "", "", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/UklibAttributes;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/FragmentIdentifier;", "(Ljava/util/Map;)V", "getDuplicates", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nArchiveUklibTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiveUklibTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/ArchiveUklibTask$UklibWithDuplicateAttributes\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n125#2:96\n152#2,3:97\n1851#3,2:100\n*S KotlinDebug\n*F\n+ 1 ArchiveUklibTask.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/publication/ArchiveUklibTask$UklibWithDuplicateAttributes\n*L\n52#1:96\n52#1:97,3\n52#1:100,2\n*E\n"})
    public static final class UklibWithDuplicateAttributes
    extends IllegalStateException {
        @NotNull
        private final Map<Set<String>, Set<String>> duplicates;

        /*
         * WARNING - void declaration
         */
        public UklibWithDuplicateAttributes(@NotNull Map<Set<String>, ? extends Set<String>> duplicates) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            void $this$_init__u24lambda_u242;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter(duplicates, (String)"duplicates");
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            UklibWithDuplicateAttributes uklibWithDuplicateAttributes = this;
            boolean bl = false;
            StringBuilder stringBuilder3 = $this$_init__u24lambda_u242.append("Uklib can't be published with multiple source sets that compile for the same set of targets:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            Object $this$map$iv = duplicates;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add("Target set \"" + it.getKey() + "\" appears in source sets \"" + CollectionsKt.sorted((Iterable)((Iterable)it.getValue())) + '\"');
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                StringBuilder stringBuilder4 = $this$_init__u24lambda_u242.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$_init__u24lambda_u242.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder5 = $this$_init__u24lambda_u242.append("Please move all code for each target set into a single source set");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            super(string);
            this.duplicates = duplicates;
        }

        @NotNull
        public final Map<Set<String>, Set<String>> getDuplicates() {
            return this.duplicates;
        }

        @NotNull
        public final Map<Set<String>, Set<String>> component1() {
            return this.duplicates;
        }

        @NotNull
        public final UklibWithDuplicateAttributes copy(@NotNull Map<Set<String>, ? extends Set<String>> duplicates) {
            Intrinsics.checkNotNullParameter(duplicates, (String)"duplicates");
            return new UklibWithDuplicateAttributes(duplicates);
        }

        public static /* synthetic */ UklibWithDuplicateAttributes copy$default(UklibWithDuplicateAttributes uklibWithDuplicateAttributes, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = uklibWithDuplicateAttributes.duplicates;
            }
            return uklibWithDuplicateAttributes.copy(map);
        }

        @Override
        @NotNull
        public String toString() {
            return "UklibWithDuplicateAttributes(duplicates=" + this.duplicates + ')';
        }

        public int hashCode() {
            return ((Object)this.duplicates).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UklibWithDuplicateAttributes)) {
                return false;
            }
            UklibWithDuplicateAttributes uklibWithDuplicateAttributes = (UklibWithDuplicateAttributes)other;
            return Intrinsics.areEqual(this.duplicates, uklibWithDuplicateAttributes.duplicates);
        }
    }
}

