/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeRefinerImpl;
import org.jetbrains.kotlin.types.KotlinTypeRefinerImplKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefinerKt;
import org.jetbrains.kotlin.types.checker.Ref;
import org.jetbrains.kotlin.types.checker.TypeRefinementSupport;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J-\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001aH\u0017\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000eH\u0017J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020!H\u0017J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#2\u0006\u0010\u0018\u001a\u00020\u0011H\u0017J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0017J\f\u0010'\u001a\u00020\u0007*\u00020\u000eH\u0002J\f\u0010(\u001a\u00020\u0007*\u00020\u000fH\u0002J\f\u0010)\u001a\u00020\u0007*\u00020\u000fH\u0002J\u0014\u0010*\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010+\u001a\u00020\u0001H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl;", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "isStandalone", "", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;Z)V", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "isRefinementNeededForTypeConstructorCache", "Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "refinedTypeCache", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "scopes", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "findClassAcrossModuleDependencies", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getOrPutScopeForClass", "S", "classDescriptor", "compute", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "isRefinementNeededForModule", "isRefinementNeededForTypeConstructor", "typeConstructor", "refineDescriptor", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "refineSupertypes", "", "refineType", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "areThereExpectSupertypes", "canBeCached", "needsRefinement", "refineWithRespectToAbbreviatedTypes", "refiner", "Companion", "descriptors"})
public final class KotlinTypeRefinerImpl
extends KotlinTypeRefiner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    private boolean isStandalone;
    @NotNull
    private final CacheWithNotNullValues<TypeConstructor, KotlinType> refinedTypeCache;
    @NotNull
    private final CacheWithNotNullValues<ClassifierDescriptor, Boolean> isRefinementNeededForTypeConstructorCache;
    @NotNull
    private final CacheWithNotNullValues<ClassDescriptor, MemberScope> scopes;

    public KotlinTypeRefinerImpl(@NotNull ModuleDescriptor moduleDescriptor, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.moduleDescriptor = moduleDescriptor;
        if (!this.isStandalone) {
            Ref<TypeRefinementSupport> ref = this.moduleDescriptor.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
            if (ref != null) {
                ref.setValue(new TypeRefinementSupport.Enabled(this));
            }
        }
        this.refinedTypeCache = storageManager.createCacheWithNotNullValues();
        this.isRefinementNeededForTypeConstructorCache = storageManager.createCacheWithNotNullValues();
        this.scopes = storageManager.createCacheWithNotNullValues();
    }

    private KotlinTypeRefinerImpl(ModuleDescriptor moduleDescriptor, StorageManager storageManager, boolean isStandalone) {
        this(moduleDescriptor, storageManager);
        this.isStandalone = isStandalone;
    }

    @Override
    @TypeRefinement
    @NotNull
    public KotlinType refineType(@NotNull KotlinTypeMarker type2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KotlinType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!this.needsRefinement((KotlinType)type2)) {
            kotlinType = (KotlinType)type2;
        } else if (this.canBeCached((KotlinType)type2)) {
            KotlinType cached2 = this.refinedTypeCache.computeIfAbsent(((KotlinType)type2).getConstructor(), (Function0<KotlinType>)((Function0)new Function0<KotlinType>(this, type2){
                final /* synthetic */ KotlinTypeRefinerImpl this$0;
                final /* synthetic */ KotlinTypeMarker $type;
                {
                    this.this$0 = $receiver;
                    this.$type = $type;
                    super(0);
                }

                @NotNull
                public final KotlinType invoke() {
                    ClassifierDescriptor classifierDescriptor = ((KotlinType)this.$type).getConstructor().getDeclarationDescriptor();
                    Intrinsics.checkNotNull((Object)classifierDescriptor);
                    SimpleType simpleType2 = classifierDescriptor.getDefaultType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"type.constructor.declara\u2026nDescriptor!!.defaultType");
                    return KotlinTypeRefinerImpl.access$refineWithRespectToAbbreviatedTypes(this.this$0, simpleType2, this.this$0);
                }
            }));
            kotlinType = KotlinTypeRefinerImplKt.access$restoreAdditionalTypeInformation(cached2, (KotlinType)type2);
        } else {
            kotlinType = this.refineWithRespectToAbbreviatedTypes((KotlinType)type2, this);
        }
        return kotlinType;
    }

    private final KotlinType refineWithRespectToAbbreviatedTypes(KotlinType $this$refineWithRespectToAbbreviatedTypes, KotlinTypeRefiner refiner) {
        KotlinType previousRefinement = null;
        KotlinType currentRefinement = $this$refineWithRespectToAbbreviatedTypes;
        while ((currentRefinement = (previousRefinement = currentRefinement).refine(refiner)) instanceof AbbreviatedType && !Intrinsics.areEqual((Object)currentRefinement, (Object)previousRefinement)) {
        }
        return currentRefinement;
    }

    private final boolean needsRefinement(KotlinType $this$needsRefinement) {
        return this.isRefinementNeededForTypeConstructor($this$needsRefinement.getConstructor());
    }

    private final boolean canBeCached(KotlinType $this$canBeCached) {
        return $this$canBeCached.getHasNotTrivialRefinementFactory() && $this$canBeCached.getConstructor().getDeclarationDescriptor() != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @TypeRefinement
    @NotNull
    public Collection<KotlinType> refineSupertypes(@NotNull ClassDescriptor classDescriptor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Collection<KotlinType> collection = classDescriptor2.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"classDescriptor.typeConstructor.supertypes");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection2.add(this.refineType((KotlinTypeMarker)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @TypeRefinement
    @Nullable
    public ClassifierDescriptor refineDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!(descriptor2 instanceof ClassifierDescriptorWithTypeParameters)) {
            return null;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.moduleDescriptor, classId2);
    }

    @Override
    @TypeRefinement
    @Nullable
    public ClassDescriptor findClassAcrossModuleDependencies(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(this.moduleDescriptor, classId);
    }

    @Override
    @TypeRefinement
    public boolean isRefinementNeededForModule(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        return this.moduleDescriptor != moduleDescriptor;
    }

    @Override
    @TypeRefinement
    public boolean isRefinementNeededForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return this.areThereExpectSupertypes(typeConstructor2);
        }
        ClassifierDescriptor owner = classifierDescriptor;
        return this.isRefinementNeededForTypeConstructorCache.computeIfAbsent(owner, (Function0<Boolean>)((Function0)new Function0<Boolean>(this, typeConstructor2){
            final /* synthetic */ KotlinTypeRefinerImpl this$0;
            final /* synthetic */ TypeConstructor $typeConstructor;
            {
                this.this$0 = $receiver;
                this.$typeConstructor = $typeConstructor;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return KotlinTypeRefinerImpl.access$areThereExpectSupertypes(this.this$0, this.$typeConstructor);
            }
        }));
    }

    @Override
    @TypeRefinement
    @NotNull
    public <S extends MemberScope> S getOrPutScopeForClass(@NotNull ClassDescriptor classDescriptor2, @NotNull Function0<? extends S> compute) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        S s = this.scopes.computeIfAbsent(classDescriptor2, compute);
        Intrinsics.checkNotNull(s, (String)"null cannot be cast to non-null type S of org.jetbrains.kotlin.types.KotlinTypeRefinerImpl.getOrPutScopeForClass");
        return (S)((MemberScope)s);
    }

    private final boolean areThereExpectSupertypes(TypeConstructor $this$areThereExpectSupertypes) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        areThereExpectSupertypes.1 var3_3 = areThereExpectSupertypes.1.INSTANCE;
        DFS.dfs(CollectionsKt.listOf((Object)$this$areThereExpectSupertypes), new DFS.Neighbors((Function1)var3_3){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                this.function = function2;
            }

            public final /* synthetic */ Iterable getNeighbors(Object p0) {
                return (Iterable)this.function.invoke(p0);
            }
        }, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<TypeConstructor, Unit>(this, result2){
            final /* synthetic */ KotlinTypeRefinerImpl this$0;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public boolean beforeChildren(@NotNull TypeConstructor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (KotlinTypeRefinerImplKt.access$isExpectClass(current)) {
                    ClassifierDescriptor classifierDescriptor = current.getDeclarationDescriptor();
                    if (!Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getModule(classifierDescriptor) : null), (Object)KotlinTypeRefinerImpl.access$getModuleDescriptor$p(this.this$0))) {
                        this.$result.element = true;
                        return false;
                    }
                }
                return true;
            }

            public void result() {
            }
        });
        return result2.element;
    }

    public static final /* synthetic */ KotlinType access$refineWithRespectToAbbreviatedTypes(KotlinTypeRefinerImpl $this, KotlinType $receiver, KotlinTypeRefiner refiner) {
        return $this.refineWithRespectToAbbreviatedTypes($receiver, refiner);
    }

    public static final /* synthetic */ boolean access$areThereExpectSupertypes(KotlinTypeRefinerImpl $this, TypeConstructor $receiver) {
        return $this.areThereExpectSupertypes($receiver);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(KotlinTypeRefinerImpl $this) {
        return $this.moduleDescriptor;
    }

    public /* synthetic */ KotlinTypeRefinerImpl(ModuleDescriptor moduleDescriptor, StorageManager storageManager, boolean isStandalone, DefaultConstructorMarker $constructor_marker) {
        this(moduleDescriptor, storageManager, isStandalone);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl$Companion;", "", "()V", "createStandaloneInstanceFor", "Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinTypeRefinerImpl createStandaloneInstanceFor(@NotNull ModuleDescriptor moduleDescriptor) {
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
            Intrinsics.checkNotNullExpressionValue((Object)storageManager, (String)"NO_LOCKS");
            return new KotlinTypeRefinerImpl(moduleDescriptor, storageManager, true, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

