/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a'\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\u001c\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f\u001a0\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000b\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u0018\u001a\u00020\u0014*\u00020\u0019\u001a\u0012\u0010\u0018\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u001a\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a,\u0010\u001a\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u001cH\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\u001d\u001a\u00020\u0014*\u00020\u0001\u001a\u0012\u0010\u001e\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u001f\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010 \u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010!\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000b\u001a\u0012\u0010\"\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010#\u001a\u00020\u0014*\u00020$2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010(\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010)\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010*\u001a\u00020\b\u001a\u000e\u0010+\u001a\u0004\u0018\u00010\u0017*\u00020\bH\u0002\u001a\u0014\u0010,\u001a\u00020\u0001*\u00020-2\u0006\u0010.\u001a\u00020\u0001H\u0002\u001a\u0018\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000100*\u00020\u00012\u0006\u0010\t\u001a\u00020\n\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00f2\u0001\u0004\n\u00020\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"receiverType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "getReceiverType", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "returnType", "getReturnType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "findBaseInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "findContributedInvokeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "expectedFunctionalType", "shouldCalculateReturnTypesOfFakeOverrides", "", "findSubtypeOfNonSuspendFunctionalType", "functionClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "isBuiltinFunctionalType", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "isFunctionalType", "predicate", "Lkotlin/Function1;", "isKClassType", "isKFunctionType", "isKMutableProperty", "isKProperty", "isSubtypeOfFunctionalType", "isSuspendFunctionType", "isTypeMismatchDueToNullability", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "actualType", "expectedType", "kFunctionTypeToFunctionType", "suspendFunctionTypeToFunctionType", "suspendFunctionTypeToFunctionTypeWithContinuation", "continuationClassId", "toFunctionClassKind", "typeOrDefault", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "default", "valueParameterTypesIncludingReceiver", "", "providers"})
public final class InferenceUtilsKt {
    private static final ClassId classId(ConeKotlinType $this$classId, FirSession session2) {
        if (!($this$classId instanceof ConeClassLikeType)) {
            return null;
        }
        return TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$classId, session2, null, 2, null).getLookupTag().getClassId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKProperty(@NotNull ConeKotlinType $this$isKProperty, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isKProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ClassId classId = InferenceUtilsKt.classId($this$isKProperty, session2);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual((Object)classId2.getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string2 = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.shortClassName.identifier");
        if (!StringsKt.startsWith$default((String)string2, (String)"KProperty", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKMutableProperty(@NotNull ConeKotlinType $this$isKMutableProperty, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isKMutableProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ClassId classId = InferenceUtilsKt.classId($this$isKMutableProperty, session2);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual((Object)classId2.getPackageFqName(), (Object)StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string2 = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.shortClassName.identifier");
        if (!StringsKt.startsWith$default((String)string2, (String)"KMutableProperty", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public static final FunctionClassKind functionClassKind(@NotNull ConeKotlinType $this$functionClassKind, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$functionClassKind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ClassId classId = InferenceUtilsKt.classId($this$functionClassKind, session2);
        return classId != null ? InferenceUtilsKt.toFunctionClassKind(classId) : null;
    }

    private static final FunctionClassKind toFunctionClassKind(ClassId $this$toFunctionClassKind) {
        FqName fqName2 = $this$toFunctionClassKind.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"packageFqName");
        String string2 = $this$toFunctionClassKind.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"relativeClassName.asString()");
        return FunctionClassKind.Companion.byClassNamePrefix(fqName2, string2);
    }

    public static final boolean isBuiltinFunctionalType(@NotNull ConeKotlinType $this$isBuiltinFunctionalType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return InferenceUtilsKt.functionClassKind($this$isBuiltinFunctionalType, session2) != null;
    }

    public static final boolean isBuiltinFunctionalType(@NotNull ConeClassLikeLookupTag $this$isBuiltinFunctionalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalType, (String)"<this>");
        return InferenceUtilsKt.toFunctionClassKind($this$isBuiltinFunctionalType.getClassId()) != null;
    }

    public static final boolean isFunctionalType(@NotNull ConeKotlinType $this$isFunctionalType, @NotNull FirSession session2, @NotNull Function1<? super FunctionClassKind, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType, session2);
        if (functionClassKind == null) {
            return false;
        }
        FunctionClassKind kind = functionClassKind;
        return (Boolean)predicate.invoke((Object)kind);
    }

    public static final boolean isFunctionalType(@NotNull ConeKotlinType $this$isFunctionalType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isFunctionalType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it == FunctionClassKind.Function;
        }
        return bl;
    }

    public static final boolean isSuspendFunctionType(@NotNull ConeKotlinType $this$isSuspendFunctionType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isSuspendFunctionType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it.isSuspendType();
        }
        return bl;
    }

    public static final boolean isKFunctionType(@NotNull ConeKotlinType $this$isKFunctionType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isKFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeKotlinType $this$isFunctionalType$iv = $this$isKFunctionType;
        boolean $i$f$isFunctionalType = false;
        FunctionClassKind functionClassKind = InferenceUtilsKt.functionClassKind($this$isFunctionalType$iv, session2);
        if (functionClassKind == null) {
            bl = false;
        } else {
            FunctionClassKind kind$iv;
            FunctionClassKind it = kind$iv = functionClassKind;
            boolean bl2 = false;
            bl = it.isReflectType();
        }
        return bl;
    }

    @NotNull
    public static final ConeClassLikeType kFunctionTypeToFunctionType(@NotNull ConeKotlinType $this$kFunctionTypeToFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$kFunctionTypeToFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!InferenceUtilsKt.isKFunctionType($this$kFunctionTypeToFunctionType, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isSuspendFunctionType($this$kFunctionTypeToFunctionType, session2) ? FunctionClassKind.SuspendFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$kFunctionTypeToFunctionType.getTypeArguments().length - 1));
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), $this$kFunctionTypeToFunctionType.getTypeArguments(), false, null, 8, null);
    }

    @NotNull
    public static final ConeClassLikeType suspendFunctionTypeToFunctionType(@NotNull ConeKotlinType $this$suspendFunctionTypeToFunctionType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendFunctionTypeToFunctionType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!InferenceUtilsKt.isSuspendFunctionType($this$suspendFunctionTypeToFunctionType, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isKFunctionType($this$suspendFunctionTypeToFunctionType, session2) ? FunctionClassKind.KFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$suspendFunctionTypeToFunctionType.getTypeArguments().length - 1));
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), $this$suspendFunctionTypeToFunctionType.getTypeArguments(), false, $this$suspendFunctionTypeToFunctionType.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeClassLikeType suspendFunctionTypeToFunctionTypeWithContinuation(@NotNull ConeKotlinType $this$suspendFunctionTypeToFunctionTypeWithContinuation, @NotNull FirSession session2, @NotNull ClassId continuationClassId) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)$this$suspendFunctionTypeToFunctionTypeWithContinuation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)continuationClassId, (String)"continuationClassId");
        if (!InferenceUtilsKt.isSuspendFunctionType($this$suspendFunctionTypeToFunctionTypeWithContinuation, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FunctionClassKind kind = InferenceUtilsKt.isKFunctionType($this$suspendFunctionTypeToFunctionTypeWithContinuation, session2) ? FunctionClassKind.KFunction : FunctionClassKind.Function;
        ClassId functionalTypeId = new ClassId(kind.getPackageFqName(), kind.numberedClassName($this$suspendFunctionTypeToFunctionTypeWithContinuation.getTypeArguments().length));
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType($this$suspendFunctionTypeToFunctionTypeWithContinuation.getType(), session2);
        Object[] typeArguments2 = fullyExpandedType2.getTypeArguments();
        ConeTypeProjection lastTypeArgument = (ConeTypeProjection)ArraysKt.last((Object[])typeArguments2);
        Object object = new ConeTypeProjection[]{lastTypeArgument};
        object = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ArraysKt.dropLast((Object[])typeArguments2, (int)1), (Object)TypeConstructionUtilsKt.constructClassType$default(new ConeClassLikeLookupTagImpl(continuationClassId), object, false, null, 4, null)), (Object)lastTypeArgument);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(functionalTypeId), thisCollection$iv.toArray(new ConeTypeProjection[0]), false, $this$suspendFunctionTypeToFunctionTypeWithContinuation.getAttributes());
    }

    public static final boolean isSubtypeOfFunctionalType(@NotNull ConeKotlinType $this$isSubtypeOfFunctionalType, @NotNull FirSession session2, @NotNull ConeClassLikeType expectedFunctionalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionalType, (String)"expectedFunctionalType");
        if (!InferenceUtilsKt.isBuiltinFunctionalType(expectedFunctionalType, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(session2), (KotlinTypeMarker)$this$isSubtypeOfFunctionalType, (KotlinTypeMarker)ConeTypeUtilsKt.replaceArgumentsWithStarProjections(expectedFunctionalType), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ConeKotlinType findSubtypeOfNonSuspendFunctionalType(@NotNull ConeKotlinType $this$findSubtypeOfNonSuspendFunctionalType, @NotNull FirSession session2, @NotNull ConeClassLikeType expectedFunctionalType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$findSubtypeOfNonSuspendFunctionalType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionalType, (String)"expectedFunctionalType");
        if (!(InferenceUtilsKt.isBuiltinFunctionalType(expectedFunctionalType, session2) && !InferenceUtilsKt.isSuspendFunctionType(expectedFunctionalType, session2))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ConeKotlinType coneKotlinType2 = $this$findSubtypeOfNonSuspendFunctionalType;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = InferenceUtilsKt.isSuspendFunctionType($this$findSubtypeOfNonSuspendFunctionalType, session2) || !InferenceUtilsKt.isSubtypeOfFunctionalType($this$findSubtypeOfNonSuspendFunctionalType, session2, expectedFunctionalType) ? null : (ConeClassLikeType)$this$findSubtypeOfNonSuspendFunctionalType;
        } else if (coneKotlinType2 instanceof ConeIntersectionType) {
            ConeKotlinType it;
            boolean bl;
            block20: {
                Iterable $this$any$iv = ((ConeIntersectionType)$this$findSubtypeOfNonSuspendFunctionalType).getIntersectedTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (!InferenceUtilsKt.isSuspendFunctionType(it, session2)) continue;
                        bl = true;
                        break block20;
                    }
                    bl = false;
                }
            }
            if (bl) {
                coneKotlinType = null;
            } else {
                Object v2;
                block21: {
                    Iterable $i$f$any = ((ConeIntersectionType)$this$findSubtypeOfNonSuspendFunctionalType).getIntersectedTypes();
                    for (Object element$iv : $i$f$any) {
                        it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (!(InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(it, session2, expectedFunctionalType) != null)) continue;
                        v2 = element$iv;
                        break block21;
                    }
                    v2 = null;
                }
                coneKotlinType = v2;
            }
        } else if (coneKotlinType2 instanceof ConeTypeParameterType) {
            boolean bl;
            List bounds;
            block22: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((ConeTypeParameterType)$this$findSubtypeOfNonSuspendFunctionalType).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
                }
                bounds = (List)destination$iv$iv;
                Iterable $this$any$iv = bounds;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv2;
                        boolean bl5 = false;
                        if (!InferenceUtilsKt.isSuspendFunctionType(it, session2)) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                coneKotlinType = null;
            } else {
                Object v4;
                block23: {
                    Iterable iterable = bounds;
                    for (Object t : iterable) {
                        ConeKotlinType it = (ConeKotlinType)t;
                        boolean bl6 = false;
                        if (!(InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(it, session2, expectedFunctionalType) != null)) continue;
                        v4 = t;
                        break block23;
                    }
                    v4 = null;
                }
                coneKotlinType = v4;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final FirNamedFunctionSymbol findBaseInvokeSymbol(@NotNull ConeClassLikeType $this$findBaseInvokeSymbol, @NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)$this$findBaseInvokeSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        if (!InferenceUtilsKt.isBuiltinFunctionalType($this$findBaseInvokeSymbol, session2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$findBaseInvokeSymbol.getLookupTag(), session2);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirClass firClass = firClassLikeDeclaration instanceof FirClass ? (FirClass)firClassLikeDeclaration : null;
        if (firClass == null) {
            return null;
        }
        FirClass functionN2 = firClass;
        Ref.ObjectRef baseInvokeSymbol = new Ref.ObjectRef();
        FirKotlinScopeProviderKt.unsubstitutedScope(functionN2, session2, scopeSession, false).processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>((Ref.ObjectRef<FirNamedFunctionSymbol>)baseInvokeSymbol){
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $baseInvokeSymbol;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                this.$baseInvokeSymbol.element = functionSymbol;
            }
        }));
        return (FirNamedFunctionSymbol)baseInvokeSymbol.element;
    }

    @Nullable
    public static final FirFunctionSymbol<?> findContributedInvokeSymbol(@NotNull ConeKotlinType $this$findContributedInvokeSymbol, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull ConeClassLikeType expectedFunctionalType, boolean shouldCalculateReturnTypesOfFakeOverrides) {
        Intrinsics.checkNotNullParameter((Object)$this$findContributedInvokeSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionalType, (String)"expectedFunctionalType");
        FirNamedFunctionSymbol firNamedFunctionSymbol = InferenceUtilsKt.findBaseInvokeSymbol(expectedFunctionalType, session2, scopeSession);
        if (firNamedFunctionSymbol == null) {
            return null;
        }
        FirNamedFunctionSymbol baseInvokeSymbol = firNamedFunctionSymbol;
        FakeOverrideTypeCalculator fakeOverrideTypeCalculator = shouldCalculateReturnTypesOfFakeOverrides ? (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.Forced.INSTANCE : (FakeOverrideTypeCalculator)FakeOverrideTypeCalculator.DoNothing.INSTANCE;
        FirTypeScope firTypeScope = ScopeUtilsKt.scope($this$findContributedInvokeSymbol, session2, scopeSession, fakeOverrideTypeCalculator);
        if (firTypeScope == null) {
            return null;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.ObjectRef declaredInvoke = new Ref.ObjectRef();
        scope2.processFunctionsByName(OperatorNameConventions.INVOKE, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(baseInvokeSymbol, (Ref.ObjectRef<FirNamedFunctionSymbol>)declaredInvoke){
            final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
            final /* synthetic */ Ref.ObjectRef<FirNamedFunctionSymbol> $declaredInvoke;
            {
                this.$baseInvokeSymbol = $baseInvokeSymbol;
                this.$declaredInvoke = $declaredInvoke;
                super(1);
            }

            public final void invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                if (((FirSimpleFunction)functionSymbol.getFir()).getValueParameters().size() == ((FirSimpleFunction)this.$baseInvokeSymbol.getFir()).getValueParameters().size()) {
                    this.$declaredInvoke.element = functionSymbol;
                    return;
                }
            }
        }));
        Ref.ObjectRef overriddenInvoke = new Ref.ObjectRef();
        if (declaredInvoke.element != null) {
            Object object = declaredInvoke.element;
            Intrinsics.checkNotNull((Object)object);
            FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)object, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(baseInvokeSymbol, overriddenInvoke){
                final /* synthetic */ FirNamedFunctionSymbol $baseInvokeSymbol;
                final /* synthetic */ Ref.ObjectRef<FirFunctionSymbol<?>> $overriddenInvoke;
                {
                    this.$baseInvokeSymbol = $baseInvokeSymbol;
                    this.$overriddenInvoke = $overriddenInvoke;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol functionSymbol) {
                    ProcessorAction processorAction;
                    Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                    if (!Intrinsics.areEqual((Object)functionSymbol, (Object)this.$baseInvokeSymbol)) {
                        FirCallableSymbol $this$originalForSubstitutionOverride$iv = functionSymbol;
                        boolean $i$f$getOriginalForSubstitutionOverride = false;
                        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
                        boolean $i$f$getOriginalForSubstitutionOverride2 = false;
                        FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
                        if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)(firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null)), (Object)this.$baseInvokeSymbol)) {
                            processorAction = ProcessorAction.NEXT;
                            return processorAction;
                        }
                    }
                    this.$overriddenInvoke.element = functionSymbol;
                    processorAction = ProcessorAction.STOP;
                    return processorAction;
                }
            }));
        }
        return overriddenInvoke.element != null ? (FirFunctionSymbol)declaredInvoke.element : null;
    }

    public static final boolean isKClassType(@NotNull ConeKotlinType $this$isKClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$isKClassType, (String)"<this>");
        return Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId($this$isKClassType), (Object)StandardClassIds.INSTANCE.getKClass());
    }

    private static final ConeKotlinType typeOrDefault(ConeTypeProjection $this$typeOrDefault, ConeKotlinType coneKotlinType) {
        ConeKotlinType coneKotlinType2;
        ConeTypeProjection coneTypeProjection = $this$typeOrDefault;
        if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
            coneKotlinType2 = ((ConeKotlinTypeProjection)$this$typeOrDefault).getType();
        } else if (coneTypeProjection instanceof ConeStarProjection) {
            coneKotlinType2 = coneKotlinType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType2;
    }

    @Nullable
    public static final ConeKotlinType receiverType(@NotNull ConeKotlinType $this$receiverType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!InferenceUtilsKt.isBuiltinFunctionalType($this$receiverType, session2) || !TypeUtilsKt.isExtensionFunctionType($this$receiverType, session2)) {
            return null;
        }
        ConeKotlinType expanded = TypeExpansionUtilsKt.fullyExpandedType($this$receiverType, session2);
        boolean bl = false;
        return InferenceUtilsKt.typeOrDefault(expanded.getTypeArguments()[CompilerConeAttributesKt.getContextReceiversNumberForFunctionType(expanded)], session2.getBuiltinTypes().getNothingType().getType());
    }

    @NotNull
    public static final ConeKotlinType returnType(@NotNull ConeKotlinType $this$returnType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$returnType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!($this$returnType instanceof ConeClassLikeType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return InferenceUtilsKt.typeOrDefault((ConeTypeProjection)ArraysKt.last((Object[])TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$returnType, session2, null, 2, null).getTypeArguments()), session2.getBuiltinTypes().getNullableAnyType().getType());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeKotlinType> valueParameterTypesIncludingReceiver(@NotNull ConeKotlinType $this$valueParameterTypesIncludingReceiver, @NotNull FirSession session2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$valueParameterTypesIncludingReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!($this$valueParameterTypesIncludingReceiver instanceof ConeClassLikeType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Iterable $this$map$iv = ArraysKt.dropLast((Object[])TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$valueParameterTypesIncludingReceiver, session2, null, 2, null).getTypeArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InferenceUtilsKt.typeOrDefault((ConeTypeProjection)it, session2.getBuiltinTypes().getNothingType().getType()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ConeKotlinType getReturnType(@NotNull FirAnonymousFunction $this$returnType) {
        Intrinsics.checkNotNullParameter((Object)$this$returnType, (String)"<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$returnType.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType getReceiverType(@NotNull FirAnonymousFunction $this$receiverType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"<this>");
        FirTypeRef firTypeRef = $this$receiverType.getReceiverTypeRef();
        if (firTypeRef != null) {
            FirTypeRef $this$coneTypeSafe$iv = firTypeRef;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    public static final boolean isTypeMismatchDueToNullability(@NotNull ConeTypeContext $this$isTypeMismatchDueToNullability, @NotNull ConeKotlinType actualType, @NotNull ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeMismatchDueToNullability, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        return $this$isTypeMismatchDueToNullability.isNullableType(actualType) && !$this$isTypeMismatchDueToNullability.isNullableType(expectedType) && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, $this$isTypeMismatchDueToNullability, (KotlinTypeMarker)actualType, (KotlinTypeMarker)TypeUtilsKt.withNullability$default(expectedType, ConeNullability.NULLABLE, $this$isTypeMismatchDueToNullability, null, 4, null), false, 8, null);
    }
}

