/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.calls.components.BuiltInsProviderKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceArgumentResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzerContext;
import org.jetbrains.kotlin.resolve.calls.components.ReceiverInfo;
import org.jetbrains.kotlin.resolve.calls.components.ReturnArgumentsAnalysisResult;
import org.jetbrains.kotlin.resolve.calls.components.ReturnArgumentsInfo;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.DescriptorRelatedInferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.model.BuilderInferencePosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.LambdaArgumentConstraintPositionImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceArgumentAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012JD\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bJ\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001f*\u0004\u0018\u00010\u001dH\u0002J\n\u0010 \u001a\u00020!*\u00020\nJ7\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010#*\u0004\u0018\u00010\u001d2\u0019\u0010$\u001a\u0015\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u0001H#0\u001b\u00a2\u0006\u0002\b%H\u0082\b\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u0004\u0018\u00010\u001d*\u0004\u0018\u00010\u001dH\u0002J\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001f*\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "", "callableReferenceArgumentResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceArgumentResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceArgumentResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzerContext;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "analyzeLambda", "Lorg/jetbrains/kotlin/resolve/calls/components/ReturnArgumentsAnalysisResult;", "lambda", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "diagnosticHolder", "applyResultsOfAnalyzedLambdaToCandidateSystem", "returnArgumentsAnalysisResult", "substitute", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "contextReceivers", "", "createSubstituteFunctorForLambdaAnalysis", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$SubstitutorAndStubsForLambdaAnalysis;", "forFunctionalType", "T", "f", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "receiver", "valueParameters", "SubstitutorAndStubsForLambdaAnalysis", "resolution"})
@SourceDebugExtension(value={"SMAP\nPostponedArgumentsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostponedArgumentsAnalyzer.kt\norg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n244#1:285\n244#1:286\n244#1:291\n457#2:248\n403#2:249\n1238#3,4:250\n1569#3,11:254\n1864#3,2:265\n1866#3:268\n1580#3:269\n1559#3:270\n1590#3,4:271\n1549#3:275\n1620#3,3:276\n1855#3,2:279\n1549#3:281\n1620#3,3:282\n1549#3:287\n1620#3,3:288\n1549#3:292\n1620#3,3:293\n1#4:267\n*S KotlinDebug\n*F\n+ 1 PostponedArgumentsAnalyzer.kt\norg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer\n*L\n232#1:285\n236#1:286\n240#1:291\n68#1:248\n68#1:249\n68#1:250,4\n100#1:254,11\n100#1:265,2\n100#1:268\n100#1:269\n112#1:270\n112#1:271,4\n114#1:275\n114#1:276,3\n166#1:279,2\n176#1:281\n176#1:282,3\n236#1:287\n236#1:288,3\n240#1:292\n240#1:293,3\n100#1:267\n*E\n"})
public final class PostponedArgumentsAnalyzer {
    @NotNull
    private final CallableReferenceArgumentResolver callableReferenceArgumentResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public PostponedArgumentsAnalyzer(@NotNull CallableReferenceArgumentResolver callableReferenceArgumentResolver, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceArgumentResolver, (String)"callableReferenceArgumentResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.callableReferenceArgumentResolver = callableReferenceArgumentResolver;
        this.languageVersionSettings = languageVersionSettings2;
    }

    public final void analyze(@NotNull PostponedArgumentsAnalyzerContext c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedAtom argument2, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)((Object)completionMode), (String)"completionMode");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        ResolvedAtom resolvedAtom = argument2;
        if (resolvedAtom instanceof ResolvedLambdaAtom) {
            this.analyzeLambda(c, resolutionCallbacks, (ResolvedLambdaAtom)argument2, completionMode, diagnosticsHolder);
        } else if (resolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
            this.analyzeLambda(c, resolutionCallbacks, PostponeArgumentsChecksKt.transformToResolvedLambda$default((LambdaWithTypeVariableAsExpectedTypeAtom)argument2, c.getBuilder(), diagnosticsHolder, null, null, 12, null), completionMode, diagnosticsHolder);
        } else if (resolvedAtom instanceof ResolvedCallableReferenceArgumentAtom) {
            this.callableReferenceArgumentResolver.processCallableReferenceArgument(c.getBuilder(), (ResolvedCallableReferenceArgumentAtom)argument2, diagnosticsHolder, resolutionCallbacks);
        } else {
            if (resolvedAtom instanceof ResolvedCollectionLiteralAtom) {
                String string2 = "Not supported";
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
            throw new IllegalStateException(("Unexpected resolved primitive: " + argument2.getClass().getCanonicalName()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SubstitutorAndStubsForLambdaAnalysis createSubstituteFunctorForLambdaAnalysis(@NotNull PostponedArgumentsAnalyzerContext $this$createSubstituteFunctorForLambdaAnalysis) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map<TypeVariableMarker, StubTypeMarker> stubsForPostponedVariables;
        Intrinsics.checkNotNullParameter((Object)$this$createSubstituteFunctorForLambdaAnalysis, (String)"<this>");
        Map<TypeVariableMarker, StubTypeMarker> map = stubsForPostponedVariables = $this$createSubstituteFunctorForLambdaAnalysis.bindingStubsForPostponedVariables();
        PostponedArgumentsAnalyzerContext postponedArgumentsAnalyzerContext = $this$createSubstituteFunctorForLambdaAnalysis;
        boolean $i$f$mapKeys = false;
        void var6_6 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TypeConstructorMarker typeConstructorMarker = MarkerExtensionsKt.freshTypeConstructor((TypeVariableMarker)it.getKey(), $this$createSubstituteFunctorForLambdaAnalysis);
            Map map3 = map2;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            map3.put(typeConstructorMarker, v);
        }
        TypeSubstitutorMarker currentSubstitutor2 = postponedArgumentsAnalyzerContext.buildCurrentSubstitutor(destination$iv$iv);
        return new SubstitutorAndStubsForLambdaAnalysis(stubsForPostponedVariables, (Function1<? super KotlinType, ? extends UnwrappedType>)((Function1)new Function1<KotlinType, UnwrappedType>(currentSubstitutor2, $this$createSubstituteFunctorForLambdaAnalysis){
            final /* synthetic */ TypeSubstitutorMarker $currentSubstitutor;
            final /* synthetic */ PostponedArgumentsAnalyzerContext $this_createSubstituteFunctorForLambdaAnalysis;
            {
                this.$currentSubstitutor = $currentSubstitutor;
                this.$this_createSubstituteFunctorForLambdaAnalysis = $receiver;
                super(1);
            }

            @NotNull
            public final UnwrappedType invoke(@NotNull KotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(this.$currentSubstitutor, this.$this_createSubstituteFunctorForLambdaAnalysis, it);
                Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.UnwrappedType");
                return (UnwrappedType)kotlinTypeMarker;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ReturnArgumentsAnalysisResult analyzeLambda(@NotNull PostponedArgumentsAnalyzerContext c, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull ResolvedLambdaAtom lambda2, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull KotlinDiagnosticsHolder diagnosticHolder) {
        Object object;
        UnwrappedType expectedTypeForReturnArguments;
        List list2;
        Iterable $this$mapIndexedTo$iv$iv;
        Collection destination$iv$iv;
        List expectedParametersToMatchAgainst;
        List list3;
        int n;
        void $this$mapIndexedNotNullTo$iv$iv;
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)((Object)completionMode), (String)"completionMode");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        SubstitutorAndStubsForLambdaAnalysis substitutorAndStubsForLambdaAnalysis = this.createSubstituteFunctorForLambdaAnalysis(c);
        Function1<KotlinType, UnwrappedType> substitute2 = substitutorAndStubsForLambdaAnalysis.getSubstitute();
        KotlinBuiltIns builtIns = BuiltInsProviderKt.getBuiltIns(c.getBuilder());
        List expectedParameters = this.valueParameters(lambda2.getExpectedType());
        UnwrappedType expectedReceiver = this.receiver(lambda2.getExpectedType());
        List<UnwrappedType> expectedContextReceivers = this.contextReceivers(lambda2.getExpectedType());
        UnwrappedType unwrappedType2 = lambda2.getReceiver();
        if (unwrappedType2 != null) {
            UnwrappedType it = unwrappedType2;
            boolean bl = false;
            UnwrappedType unwrappedType3 = expectedReceiver;
            if (unwrappedType3 == null) {
                List list4 = expectedParameters;
                unwrappedType3 = list4 != null ? (UnwrappedType)CollectionsKt.getOrNull(list4, (int)0) : null;
            }
            unwrappedType = PostponedArgumentsAnalyzer.analyzeLambda$expectedOrActualType(substitute2, c, unwrappedType3, lambda2.getReceiver());
        } else {
            unwrappedType = null;
        }
        UnwrappedType receiver = unwrappedType;
        Iterable $this$mapIndexedNotNull$iv = lambda2.getContextReceivers();
        boolean $i$f$mapIndexedNotNull = false;
        Iterable bl = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        Iterable $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            UnwrappedType it$iv$iv;
            void contextReceiver2;
            void element$iv$iv;
            int n2;
            if ((n2 = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv2 = n2;
            n = 0;
            UnwrappedType unwrappedType4 = (UnwrappedType)element$iv$iv;
            int i = index$iv$iv2;
            boolean bl2 = false;
            List<UnwrappedType> list5 = expectedContextReceivers;
            if (PostponedArgumentsAnalyzer.analyzeLambda$expectedOrActualType(substitute2, c, list5 != null ? (UnwrappedType)CollectionsKt.getOrNull(list5, (int)i) : null, (UnwrappedType)contextReceiver2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List contextReceivers = (List)destination$iv$iv2;
        if (receiver == null && expectedReceiver != null && expectedParameters != null) {
            list3 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)expectedReceiver), (Iterable)expectedParameters);
        } else if (receiver == null && expectedReceiver != null) {
            list3 = CollectionsKt.listOf((Object)expectedReceiver);
        } else if (receiver != null && expectedReceiver == null) {
            List list6 = expectedParameters;
            list3 = list6 != null ? CollectionsKt.drop((Iterable)list6, (int)1) : null;
        } else {
            list3 = expectedParameters;
        }
        List list7 = expectedParametersToMatchAgainst = list3;
        if (list7 != null) {
            Iterable $this$mapIndexed$iv = list7;
            boolean $i$f$mapIndexed = false;
            $this$forEachIndexed$iv$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index2;
                void expected;
                int n3;
                if ((n3 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                UnwrappedType index$iv$iv2 = (UnwrappedType)item$iv$iv;
                n = n3;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                UnwrappedType unwrappedType5 = PostponedArgumentsAnalyzer.analyzeLambda$expectedOrActualType(substitute2, c, (UnwrappedType)expected, (UnwrappedType)CollectionsKt.getOrNull(lambda2.getParameters(), (int)index2));
                if (unwrappedType5 == null) {
                    SimpleType simpleType2 = builtIns.getNothingType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"builtIns.nothingType");
                    unwrappedType5 = simpleType2;
                }
                collection.add(unwrappedType5);
            }
            list2 = (List)destination$iv$iv;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = lambda2.getParameters();
            boolean $i$f$map = false;
            $this$mapIndexedTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(substitute2.invoke(item$iv$iv));
            }
            list2 = (List)destination$iv$iv;
        }
        List parameters2 = list2;
        UnwrappedType rawReturnType = lambda2.getReturnType();
        UnwrappedType unwrappedType6 = expectedTypeForReturnArguments = c.canBeProper(rawReturnType) ? (UnwrappedType)substitute2.invoke((Object)rawReturnType) : (!rawReturnType.isMarkedNullable() && c.hasUpperOrEqualUnitConstraint(rawReturnType) ? (UnwrappedType)builtIns.getUnitType() : null);
        Object object2 = lambda2.getExpectedType();
        if (object2 != null && (object2 = ((KotlinType)object2).getAnnotations()) != null) {
            Object annotations2 = object2;
            boolean bl5 = false;
            object = receiver != null || expectedReceiver == null ? annotations2 : (Annotations)new FilteredAnnotations((Annotations)annotations2, true, (Function1<? super FqName, Boolean>)((Function1)analyzeLambda.convertedAnnotations.1.1.INSTANCE));
        } else {
            object = null;
        }
        Object convertedAnnotations2 = object;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = lambda2.getAtom();
        boolean bl6 = lambda2.isSuspend();
        Object object3 = convertedAnnotations2;
        if (object3 == null) {
            object3 = Annotations.Companion.getEMPTY();
        }
        Map<TypeVariableMarker, StubTypeMarker> map = substitutorAndStubsForLambdaAnalysis.getStubsForPostponedVariables();
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<org.jetbrains.kotlin.resolve.calls.inference.model.NewTypeVariable, org.jetbrains.kotlin.types.StubTypeForBuilderInference>");
        ReturnArgumentsAnalysisResult returnArgumentsAnalysisResult = resolutionCallbacks.analyzeAndGetLambdaReturnArguments(lambdaKotlinCallArgument, bl6, receiver, contextReceivers, parameters2, expectedTypeForReturnArguments, (Annotations)object3, map);
        this.applyResultsOfAnalyzedLambdaToCandidateSystem(c, lambda2, returnArgumentsAnalysisResult, completionMode, diagnosticHolder, substitute2);
        return returnArgumentsAnalysisResult;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyResultsOfAnalyzedLambdaToCandidateSystem(@NotNull PostponedArgumentsAnalyzerContext c, @NotNull ResolvedLambdaAtom lambda2, @NotNull ReturnArgumentsAnalysisResult returnArgumentsAnalysisResult, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull KotlinDiagnosticsHolder diagnosticHolder, @NotNull Function1<? super KotlinType, ? extends UnwrappedType> substitute2) {
        boolean shouldUseBuilderInference;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)returnArgumentsAnalysisResult, (String)"returnArgumentsAnalysisResult");
        Intrinsics.checkNotNullParameter((Object)((Object)completionMode), (String)"completionMode");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter(substitute2, (String)"substitute");
        ReturnArgumentsInfo returnArgumentsInfo = returnArgumentsAnalysisResult.component1();
        InferenceSession inferenceSession = returnArgumentsAnalysisResult.component2();
        boolean hasInapplicableCallForBuilderInference = returnArgumentsAnalysisResult.component3();
        if (hasInapplicableCallForBuilderInference) {
            InferenceSession inferenceSession2 = inferenceSession;
            if (inferenceSession2 != null) {
                inferenceSession2.initializeLambda(lambda2);
            }
            c.getBuilder().markCouldBeResolvedWithUnrestrictedBuilderInference();
            c.getBuilder().removePostponedVariables();
            return;
        }
        List returnArguments = returnArgumentsInfo.getNonErrorArguments();
        Iterable $this$forEach$iv = returnArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallArgument it = (KotlinCallArgument)element$iv;
            boolean bl = false;
            DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(c, it);
        }
        KotlinCallArgument lastExpression = returnArgumentsInfo.getLastExpression();
        List allReturnArguments = lastExpression != null && returnArgumentsInfo.getLastExpressionCoercedToUnit() && DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(c, lastExpression) ? CollectionsKt.plus((Collection)returnArguments, (Object)lastExpression) : returnArguments;
        Iterable $this$map$iv = allReturnArguments;
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinCallArgument kotlinCallArgument = (KotlinCallArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(PostponeArgumentsChecksKt.resolveKtPrimitive(c.getBuilder(), (KotlinCallArgument)it, (UnwrappedType)substitute2.invoke((Object)lambda2.getReturnType()), diagnosticHolder, ReceiverInfo.Companion.getNotReceiver(), null, inferenceSession));
        }
        List subResolvedKtPrimitives = (List)destination$iv$iv;
        if (!returnArgumentsInfo.getReturnArgumentsExist()) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(lambda2.getReturnType()).getUnitType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"lambda.returnType.builtIns.unitType");
            SimpleType unitType = simpleType2;
            UnwrappedType lambdaReturnType = (UnwrappedType)substitute2.invoke((Object)lambda2.getReturnType());
            c.getBuilder().addSubtypeConstraint(unitType, lambdaReturnType, new LambdaArgumentConstraintPositionImpl(lambda2));
        }
        lambda2.setAnalyzedResults(returnArgumentsInfo, subResolvedKtPrimitives);
        boolean bl3 = shouldUseBuilderInference = lambda2.getAtom().getHasBuilderInferenceAnnotation() || this.languageVersionSettings.supportsFeature(LanguageFeature.UseBuilderInferenceWithoutAnnotation);
        if (inferenceSession != null && shouldUseBuilderInference) {
            ConstraintSystemBuilder constraintSystemBuilder = c.getBuilder();
            Map<TypeConstructor, UnwrappedType> postponedVariables = inferenceSession.inferPostponedVariables(lambda2, constraintSystemBuilder, completionMode, diagnosticHolder);
            if (postponedVariables == null) {
                c.getBuilder().removePostponedVariables();
                return;
            }
            for (Map.Entry<TypeConstructor, UnwrappedType> entry : postponedVariables.entrySet()) {
                VariableWithConstraints variableWithConstraints;
                TypeConstructor constructor2 = entry.getKey();
                UnwrappedType resultType = entry.getValue();
                if (constraintSystemBuilder.currentStorage().getNotFixedTypeVariables().get(constructor2) == null) continue;
                TypeVariableMarker variable2 = variableWithConstraints.getTypeVariable();
                c.getBuilder().unmarkPostponedVariable(variable2);
                c.getBuilder().addSubtypeConstraint(resultType, MarkerExtensionsKt.defaultType(variable2, c), BuilderInferencePosition.INSTANCE);
            }
            c.removePostponedTypeVariablesFromConstraints(postponedVariables.keySet());
        }
    }

    public static /* synthetic */ void applyResultsOfAnalyzedLambdaToCandidateSystem$default(PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, PostponedArgumentsAnalyzerContext postponedArgumentsAnalyzerContext, ResolvedLambdaAtom resolvedLambdaAtom, ReturnArgumentsAnalysisResult returnArgumentsAnalysisResult, ConstraintSystemCompletionMode constraintSystemCompletionMode, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, Function1 function1, int n, Object object) {
        if ((n & 0x20) != 0) {
            function1 = postponedArgumentsAnalyzer.createSubstituteFunctorForLambdaAnalysis(postponedArgumentsAnalyzerContext).getSubstitute();
        }
        postponedArgumentsAnalyzer.applyResultsOfAnalyzedLambdaToCandidateSystem(postponedArgumentsAnalyzerContext, resolvedLambdaAtom, returnArgumentsAnalysisResult, constraintSystemCompletionMode, kotlinDiagnosticsHolder, function1);
    }

    private final UnwrappedType receiver(UnwrappedType $this$receiver) {
        UnwrappedType unwrappedType;
        PostponedArgumentsAnalyzer postponedArgumentsAnalyzer = this;
        UnwrappedType $this$forFunctionalType$iv = $this$receiver;
        boolean $i$f$forFunctionalType = false;
        UnwrappedType unwrappedType2 = $this$forFunctionalType$iv;
        boolean bl = unwrappedType2 != null ? FunctionTypesKt.isBuiltinFunctionalType(unwrappedType2) : false;
        if (bl) {
            UnwrappedType $this$receiver_u24lambda_u247 = $this$forFunctionalType$iv;
            boolean bl2 = false;
            KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType($this$receiver_u24lambda_u247);
            unwrappedType = kotlinType != null ? kotlinType.unwrap() : null;
        } else {
            unwrappedType = null;
        }
        return unwrappedType;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UnwrappedType> contextReceivers(UnwrappedType $this$contextReceivers) {
        List list2;
        PostponedArgumentsAnalyzer postponedArgumentsAnalyzer = this;
        UnwrappedType $this$forFunctionalType$iv = $this$contextReceivers;
        boolean $i$f$forFunctionalType = false;
        UnwrappedType unwrappedType = $this$forFunctionalType$iv;
        boolean bl = unwrappedType != null ? FunctionTypesKt.isBuiltinFunctionalType(unwrappedType) : false;
        if (bl) {
            void $this$mapTo$iv$iv;
            UnwrappedType $this$contextReceivers_u24lambda_u249 = $this$forFunctionalType$iv;
            boolean bl2 = false;
            Iterable $this$map$iv = FunctionTypesKt.getContextReceiverTypesFromFunctionType($this$contextReceivers_u24lambda_u249);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.unwrap());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UnwrappedType> valueParameters(UnwrappedType $this$valueParameters) {
        List list2;
        PostponedArgumentsAnalyzer postponedArgumentsAnalyzer = this;
        UnwrappedType $this$forFunctionalType$iv = $this$valueParameters;
        boolean $i$f$forFunctionalType = false;
        UnwrappedType unwrappedType = $this$forFunctionalType$iv;
        boolean bl = unwrappedType != null ? FunctionTypesKt.isBuiltinFunctionalType(unwrappedType) : false;
        if (bl) {
            void $this$mapTo$iv$iv;
            UnwrappedType $this$valueParameters_u24lambda_u2411 = $this$forFunctionalType$iv;
            boolean bl2 = false;
            Iterable $this$map$iv = FunctionTypesKt.getValueParameterTypesFromFunctionType($this$valueParameters_u24lambda_u2411);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getType().unwrap());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final UnwrappedType analyzeLambda$expectedOrActualType(Function1<? super KotlinType, ? extends UnwrappedType> substitute2, PostponedArgumentsAnalyzerContext $c, UnwrappedType expected, UnwrappedType actual) {
        UnwrappedType unwrappedType;
        UnwrappedType expectedSubstituted;
        UnwrappedType unwrappedType2 = expected;
        UnwrappedType unwrappedType3 = expectedSubstituted = unwrappedType2 != null ? (UnwrappedType)substitute2.invoke((Object)unwrappedType2) : null;
        if (expectedSubstituted != null && $c.canBeProper(expectedSubstituted)) {
            unwrappedType = expectedSubstituted;
        } else {
            UnwrappedType unwrappedType4 = actual;
            unwrappedType = unwrappedType4 != null ? (UnwrappedType)substitute2.invoke((Object)unwrappedType4) : null;
        }
        return unwrappedType;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J5\u0010\u0011\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$SubstitutorAndStubsForLambdaAnalysis;", "", "stubsForPostponedVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/types/model/StubTypeMarker;", "substitute", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "(Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getStubsForPostponedVariables", "()Ljava/util/Map;", "getSubstitute", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolution"})
    public static final class SubstitutorAndStubsForLambdaAnalysis {
        @NotNull
        private final Map<TypeVariableMarker, StubTypeMarker> stubsForPostponedVariables;
        @NotNull
        private final Function1<KotlinType, UnwrappedType> substitute;

        public SubstitutorAndStubsForLambdaAnalysis(@NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> stubsForPostponedVariables, @NotNull Function1<? super KotlinType, ? extends UnwrappedType> substitute2) {
            Intrinsics.checkNotNullParameter(stubsForPostponedVariables, (String)"stubsForPostponedVariables");
            Intrinsics.checkNotNullParameter(substitute2, (String)"substitute");
            this.stubsForPostponedVariables = stubsForPostponedVariables;
            this.substitute = substitute2;
        }

        @NotNull
        public final Map<TypeVariableMarker, StubTypeMarker> getStubsForPostponedVariables() {
            return this.stubsForPostponedVariables;
        }

        @NotNull
        public final Function1<KotlinType, UnwrappedType> getSubstitute() {
            return this.substitute;
        }

        @NotNull
        public final Map<TypeVariableMarker, StubTypeMarker> component1() {
            return this.stubsForPostponedVariables;
        }

        @NotNull
        public final Function1<KotlinType, UnwrappedType> component2() {
            return this.substitute;
        }

        @NotNull
        public final SubstitutorAndStubsForLambdaAnalysis copy(@NotNull Map<TypeVariableMarker, ? extends StubTypeMarker> stubsForPostponedVariables, @NotNull Function1<? super KotlinType, ? extends UnwrappedType> substitute2) {
            Intrinsics.checkNotNullParameter(stubsForPostponedVariables, (String)"stubsForPostponedVariables");
            Intrinsics.checkNotNullParameter(substitute2, (String)"substitute");
            return new SubstitutorAndStubsForLambdaAnalysis(stubsForPostponedVariables, substitute2);
        }

        public static /* synthetic */ SubstitutorAndStubsForLambdaAnalysis copy$default(SubstitutorAndStubsForLambdaAnalysis substitutorAndStubsForLambdaAnalysis, Map map, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                map = substitutorAndStubsForLambdaAnalysis.stubsForPostponedVariables;
            }
            if ((n & 2) != 0) {
                function1 = substitutorAndStubsForLambdaAnalysis.substitute;
            }
            return substitutorAndStubsForLambdaAnalysis.copy(map, function1);
        }

        @NotNull
        public String toString() {
            return "SubstitutorAndStubsForLambdaAnalysis(stubsForPostponedVariables=" + this.stubsForPostponedVariables + ", substitute=" + this.substitute + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.stubsForPostponedVariables).hashCode();
            result2 = result2 * 31 + this.substitute.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubstitutorAndStubsForLambdaAnalysis)) {
                return false;
            }
            SubstitutorAndStubsForLambdaAnalysis substitutorAndStubsForLambdaAnalysis = (SubstitutorAndStubsForLambdaAnalysis)other;
            if (!Intrinsics.areEqual(this.stubsForPostponedVariables, substitutorAndStubsForLambdaAnalysis.stubsForPostponedVariables)) {
                return false;
            }
            return Intrinsics.areEqual(this.substitute, substitutorAndStubsForLambdaAnalysis.substitute);
        }
    }
}

