/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAmbiguousAnonymousTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "singleExpressionType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "getSingleExpressionType", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAmbiguousAnonymousTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAmbiguousAnonymousTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAmbiguousAnonymousTypeChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,65:1\n1747#2,3:66\n1549#2:70\n1620#2,3:71\n40#3:69\n*S KotlinDebug\n*F\n+ 1 FirAmbiguousAnonymousTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAmbiguousAnonymousTypeChecker\n*L\n27#1:66,3\n56#1:70\n56#1:71,3\n31#1:69\n*E\n"})
public final class FirAmbiguousAnonymousTypeChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAmbiguousAnonymousTypeChecker INSTANCE = new FirAmbiguousAnonymousTypeChecker();

    private FirAmbiguousAnonymousTypeChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirPureAbstractElement firPureAbstractElement;
        FirDeclaration it;
        boolean bl;
        block17: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (!(declaration instanceof FirFunction) && !(declaration instanceof FirProperty)) {
                return;
            }
            if (!(declaration instanceof FirCallableDeclaration)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (DeclarationUtilsKt.getHasExplicitReturnType(((FirCallableDeclaration)declaration).getSymbol())) {
                return;
            }
            Iterable $this$any$iv = context.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(DeclarationUtilsKt.isLocalMember(it) || it instanceof FirAnonymousObject)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isInline = false;
        if (!TypeUtilsKt.shouldApproximateAnonymousTypesOfNonLocalDeclaration(TypeUtilsKt.visibilityForApproximation(declaration, (FirDeclaration)CollectionsKt.lastOrNull(context.getContainingDeclarations())), $this$isInline$iv.getStatus().isInline())) {
            return;
        }
        Object object = (FirCallableDeclaration)declaration;
        if (object instanceof FirProperty) {
            firPureAbstractElement = ((FirProperty)declaration).getInitializer();
            if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getTypeRef()) == null) {
                FirPureAbstractElement firPureAbstractElement2 = ((FirProperty)declaration).getGetter();
                firPureAbstractElement = firPureAbstractElement2 != null && (firPureAbstractElement2 = firPureAbstractElement2.getBody()) != null ? this.getSingleExpressionType((FirBlock)firPureAbstractElement2) : null;
            }
        } else if (object instanceof FirFunction) {
            FirBlock firBlock = ((FirFunction)declaration).getBody();
            firPureAbstractElement = firBlock != null ? this.getSingleExpressionType(firBlock) : null;
        } else {
            throw new IllegalStateException("Should not be there".toString());
        }
        if (firPureAbstractElement == null) {
            return;
        }
        FirPureAbstractElement typeRef = firPureAbstractElement;
        FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(FirTypeUtilsKt.getConeType((FirTypeRef)typeRef), context.getSession());
        if (firClassifierSymbol == null) {
            return;
        }
        FirClassifierSymbol<?> classSymbol = firClassifierSymbol;
        if (classSymbol instanceof FirAnonymousObjectSymbol && ((FirAnonymousObjectSymbol)classSymbol).getResolvedSuperTypeRefs().size() > 1) {
            Collection<ConeKotlinType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = ((FirAnonymousObjectSymbol)classSymbol).getResolvedSuperTypeRefs();
            KtDiagnosticFactory1<Collection<ConeKotlinType>> ktDiagnosticFactory1 = FirErrors.INSTANCE.getAMBIGUOUS_ANONYMOUS_TYPE_INFERRED();
            AbstractKtSourceElement abstractKtSourceElement = declaration.getSource();
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it2));
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)collection, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final FirTypeRef getSingleExpressionType(FirBlock $this$singleExpressionType) {
        FirSingleExpressionBlock firSingleExpressionBlock = $this$singleExpressionType instanceof FirSingleExpressionBlock ? (FirSingleExpressionBlock)$this$singleExpressionType : null;
        FirStatement firStatement = firSingleExpressionBlock != null ? firSingleExpressionBlock.getStatement() : null;
        FirExpression firExpression2 = firStatement instanceof FirReturnExpression ? (FirReturnExpression)firStatement : null;
        return firExpression2 != null && (firExpression2 = ((FirReturnExpression)firExpression2).getResult()) != null ? firExpression2.getTypeRef() : null;
    }
}

