/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceObjectCallsLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInheritedDefaultMethodsOnClassesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceObjectCallsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n1#2:349\n*E\n"})
final class InterfaceObjectCallsLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InterfaceObjectCallsLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrClassSymbol irClassSymbol;
        IrSimpleFunction resolved;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getSuperQualifierSymbol() != null && !IrUtilsKt.isSuperToAny(expression2)) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!IrUtilsKt.hasInterfaceParent(callee)) {
            boolean bl;
            IrExpression irExpression = expression2.getDispatchReceiver();
            if (irExpression != null) {
                IrExpression $this$visitCall_u24lambda_u240 = irExpression;
                boolean bl2 = false;
                bl = JvmIrUtilsKt.isJvmInterface(JvmIrTypeUtilsKt.getErasedUpperBound($this$visitCall_u24lambda_u240.getType()));
            } else {
                bl = false;
            }
            if (!bl) {
                return super.visitCall(expression2);
            }
        }
        IrSimpleFunction irSimpleFunction = resolved = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(callee, false, null, 3, null);
        if (!(irSimpleFunction != null ? IrUtilsKt.isMethodOfAny(irSimpleFunction) : false)) {
            return super.visitCall(expression2);
        }
        IrClassSymbol it = irClassSymbol = this.context.getIrBuiltIns().getAnyClass();
        boolean bl = false;
        IrClassSymbol newSuperQualifierSymbol = expression2.getSuperQualifierSymbol() != null ? irClassSymbol : null;
        return super.visitCall(IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, resolved, false, false, newSuperQualifierSymbol, null, 44, null));
    }
}

